/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import io.github.lukebemish.dynamic_asset_generator.DynAssetGenServerPlanner;
import io.github.lukebemish.dynamic_asset_generator.Pair;
import io.github.lukebemish.dynamic_asset_generator.tags.TagBuilder;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class DynAssetGeneratorServerAPI {
    private static final HashMap<ResourceLocation, TagBuilder> tagBuilderMap = new HashMap();

    public static void planLoadingStream(ResourceLocation location, Supplier<InputStream> sup) {
        DynAssetGenServerPlanner.planLoadingStream(location, sup);
    }

    public static void planLoaders(Supplier<Map<ResourceLocation, Supplier<InputStream>>> suppliers) {
        DynAssetGenServerPlanner.planLoaders(suppliers);
    }

    public static void planTagFile(ResourceLocation tagLocation, ResourceLocation toAdd) {
        DynAssetGeneratorServerAPI.planTagFileConditional(tagLocation, List.of(new Pair<ResourceLocation, Supplier<Boolean>>(toAdd, () -> true)));
    }

    public static void planTagFile(ResourceLocation tagLocation, Collection<ResourceLocation> toAdd) {
        DynAssetGeneratorServerAPI.planTagFileConditional(tagLocation, toAdd.stream().map(rl -> new Pair<ResourceLocation, Supplier<Boolean>>((ResourceLocation)rl, () -> true)).toList());
    }

    public static void planTagFileConditional(ResourceLocation tagLocation, Pair<ResourceLocation, Supplier<Boolean>> toAdd) {
        DynAssetGeneratorServerAPI.planTagFileConditional(tagLocation, List.of(toAdd));
    }

    public static void planTagFileConditional(ResourceLocation tagLocation, Collection<Pair<ResourceLocation, Supplier<Boolean>>> toAdd) {
        if (!tagBuilderMap.containsKey(tagLocation)) {
            TagBuilder builder = new TagBuilder();
            tagBuilderMap.put(tagLocation, builder);
            DynAssetGeneratorServerAPI.planLoadingStream(new ResourceLocation(tagLocation.m_135827_(), "tags/" + tagLocation.m_135815_() + ".json"), builder.supply());
        }
        for (Pair<ResourceLocation, Supplier<Boolean>> p : toAdd) {
            tagBuilderMap.get(tagLocation).add(p);
        }
    }
}

